IF  EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'CD_CHAVE' AND OBJECT_ID = OBJECT_ID('PRC_FILIAL_CONFIG'))
BEGIN
ALTER TABLE PRC_FILIAL_CONFIG DISABLE CHANGE_TRACKING;

ALTER TABLE PRC_FILIAL_CONFIG    DROP CONSTRAINT PK_PRC_FILIAL_CONFIG;


--Drop index
-------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PRC_FILIAL_CONFIG]') AND name = N'IX_PRC_FILIAL_CONFIG_CD_CHAVE')
BEGIN
	DROP INDEX [IX_PRC_FILIAL_CONFIG_CD_CHAVE] ON [dbo].[PRC_FILIAL_CONFIG];
END;

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PRC_FILIAL_CONFIG]') AND name = N'IX_DBAONL_PRC_FILIAL_CONFIG_01')
BEGIN
	DROP INDEX [IX_DBAONL_PRC_FILIAL_CONFIG_01] ON [dbo].[PRC_FILIAL_CONFIG];
END;

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PRC_FILIAL_CONFIG]') AND name = N'IX_DBAONL_PRC_FILIAL_CONFIG_02')
BEGIN
	DROP INDEX [IX_DBAONL_PRC_FILIAL_CONFIG_02] ON [dbo].[PRC_FILIAL_CONFIG];
END;
-------------------------------------------------------------------------

ALTER TABLE PRC_FILIAL_CONFIG ALTER COLUMN CD_CHAVE    NVARCHAR (100) NOT NULL;

ALTER TABLE PRC_FILIAL_CONFIG ADD CONSTRAINT PK_PRC_FILIAL_CONFIG PRIMARY KEY (CD_EMP, CD_FILIAL, CD_CHAVE);

ALTER TABLE PRC_FILIAL_CONFIG    ENABLE CHANGE_TRACKING;


---create index----------------------------------------------------------

CREATE INDEX [IX_PRC_FILIAL_CONFIG_CD_CHAVE] ON [dbo].[PRC_FILIAL_CONFIG]
( [CD_CHAVE] ASC, CD_FILIAL ASC, VALOR ASC);


CREATE INDEX [IX_DBAONL_PRC_FILIAL_CONFIG_01] ON [dbo].[PRC_FILIAL_CONFIG]
( [CD_FILIAL] ASC,    [CD_CHAVE] ASC) ;

CREATE INDEX [IX_DBAONL_PRC_FILIAL_CONFIG_02] ON [dbo].[PRC_FILIAL_CONFIG]
([CD_EMP] ASC,    [CD_CHAVE] ASC);
-------------------------------------------------------------------------


END